/*****************************************************************************
*  LPC43xx SCT blinky program
*
*  1. Use SCT timer to generate a 10 msec timer tick (interrupt driven).
*  2. Toggle P4_14 every 100 msec
*****************************************************************************/
#include "nxp_lpc43xx.h"
#include "mcb4300.h"

extern void SCT_Init(void);

void SCT_IRQHandler(void)
{                                                  // SCT Interrupt Handler (10 msec)
  static uint8_t cnt = 0;

    if (++cnt > 20)                                // 20 * 10 msec = 200 msec
    {
        cnt = 0;
        LPC_GPIO_PORT->NOT[4] = (1 << 14);         // toggle pin P4_14
    }
    LPC_SCT->EVFLAG = 0x00000001;                  // clear event 0 flag
}

int main (void) 
{
    SystemCoreClockUpdate ();                      // Update system core clock

    LPC_CCU1->CLK_M4_SCT_CFG  = (1 << 0);          // enable SCT clock in CCU1 

    MCB4300_Init();                                // Initialize MCB4300 board stuff
    SCT_Init();                                    // Initialize SCT1

    while (1)                                      // loop forever
    {
    }
}
